function [guihand,edmulti,contbut,quitbut]=...
                pmnshow(smat,guihand,edmulti,contbut,quitbut);
% PMNSHOW
% -------
%          Function utilizing MATLAB's GUI-facilities for presenting
%          slide shows

% Written by: Magnus Norgaard, IAU/IMM, Technical University of Denmark
% LastEditDate: Jan. 15, 2000.
if nargin<=1,
  guihand=gcf;
  smat=' ';

  edmulti = uicontrol(...
     'BackgroundColor','blue',...
     'ForegroundColor','white',...
     'HorizontalAlignment','left',...
     'Style','edit',...
     'String',smat,...,
     'Interruptible','off',...
     'Units','normalized',... 
     'Position',[ 0.04 0.05 0.7 0.4 ],...
     'Max',2);

  fram =  uicontrol(...
	'BackgroundColor','blue',... 
	'Style','frame',...
	'Interruptible','off',...
	'Units','normalized',... 
	'Position',[ 0.77 0.05 0.2 0.4 ]); 

  contbut = uicontrol(...
	'String','CONTINUE',... 
	'Style','pushbutton',... 
	'Units','normalized',...
	'Position',[ 0.8 0.30 0.15 0.09 ],... 
	'CallBack','uiresume;');
	

   quitbut = uicontrol(... 
	'CallBack','',...
	'String','QUIT',... 
	'Style','pushbutton',...
	'Interruptible','off',...
	'CallBack','StopDemo=1;uiresume;',...
	'Units','normalized',...
	'Position',[ 0.8 0.10 0.15 0.09 ]);
	
  set(gcf,'NumberTitle','off');

else
   set(edmulti,'String',smat);
   contpress=0;
   set(quitbut,'Enable','on');
   set(contbut,'Enable','on');
   drawnow;
%   waitforbuttonpress;
%   pause(1),
uiwait(guihand);
   drawnow
   set(quitbut,'Enable','off');
   set(contbut,'Enable','off');
   drawnow;
end
